/**
 *  Form Wizard
 */

var SEKOLAH_ID = "Mzg=";
var BASE_URL = "https://json.literasigma.com";

("use strict");

(function () {
  const loadingSpinner = (formVal, time = 1500) => {
    console.log("loadingSpinner  ", time);
    formVal.block({
      message:
        '<div class="d-flex justify-content-center"><div class="sk-wave m-0">' +
        '<div class="sk-rect sk-wave-rect"></div><div class="sk-rect sk-wave-rect"></div>' +
        '<div class="sk-rect sk-wave-rect"></div><div class="sk-rect sk-wave-rect"></div>' +
        '<div class="sk-rect sk-wave-rect"></div></div></div>',
      css: {
        backgroundColor: "transparent",
        color: "#fff",
        border: "0",
      },
      overlayCSS: {
        opacity: 0.5,
      },
      timeout: time,
    });
  };

  const resolveSpinner = (formVal, callback = null) => {
    formVal.block({
      message: '<p class="mb-0">Tunggu...</p>',
      timeout: 1000,
      css: {
        backgroundColor: "transparent",
        color: "#fff",
        border: "0",
      },
      overlayCSS: {
        opacity: 0.25,
      },
      onUnblock: function () {
        formVal.block({
          message:
            '<span class="badge bg-success p-3"><i class="ti ti-check"></i> Berhasil</span>',
          timeout: 500,
          css: {
            backgroundColor: "transparent",
            color: "#fff",
            border: "0",
          },
          overlayCSS: {
            opacity: 0.25,
          },
          onUnblock: function () {
            if (typeof callback === "function") callback();
          },
        });
      },
    });
  };

  const rejectSpinner = (
    formVal,
    message = "Terjadi kesalahan",
    callback = null
  ) => {
    formVal.unblock();
    Swal.fire({
      icon: "error",
      title: "Gagal",
      text: message,
      confirmButtonText: "OK", // Ini memastikan tombol Confirm ditampilkan
      confirmButtonColor: "#3085d6", // Warna biru default SweetAlert2
      customClass: {
        confirmButton: "btn btn-primary waves-effect waves-light", // Tambahkan class custom Bootstrap
      },
      buttonsStyling: false,
    }).then(() => {
      if (typeof callback === "function") callback();
    });
  };

  $.ajax({
    url: BASE_URL + "/getActivePpdb",
    type: "POST",
    dataType: "json",
    data: {
      id: SEKOLAH_ID,
    },
    success: (e) => {
      console.log(e);
      if (e.status == false) {
        $(".box-alert").css("display", "block");
      }

      const $step = $('.step[data-target="#pembayaran-validation"]');
      if(e.status == true && e.amount == 0){
          $step.hide();
          $step.prev('.line').hide();
      } else {
          $step.show();
        $step.prev('.line').show();
      }
    },
  });

  // Wizard Validation
  // --------------------------------------------------------------------
  const wizardValidation = document.querySelector("#wizard-validation");
  if (wizardValidation) {
    // Wizard form
    const wizardValidationForm = wizardValidation.querySelector(
      "#wizard-validation-form"
    );
    // Wizard steps
    const wizardValidationFormStep1 = wizardValidationForm.querySelector(
      "#data-ortu-validation"
    );
    const wizardValidationFormStep2 = wizardValidationForm.querySelector(
      "#data-siswa-validation"
    );
    const wizardValidationFormStep3 = wizardValidationForm.querySelector(
      "#pembayaran-validation"
    );
    // Wizard next prev button
    const wizardValidationNext = [].slice.call(
      wizardValidationForm.querySelectorAll(".btn-next")
    );
    const wizardValidationPrev = [].slice.call(
      wizardValidationForm.querySelectorAll(".btn-prev")
    );

    const validationStepper = new Stepper(wizardValidation, {
      linear: true,
    });

    // Validation Data Orang Tua
    const kk = document.querySelector('[name="formValidationParentkk"]');
    const nik = document.querySelector('[name="formValidationNik"]');
    const nameOrtu = document.querySelector(
      '[name="formValidationParentName"]'
    );
    const pendapatan = document.querySelector(
      '[name="formValidationPendapatan"]'
    );
    const pekerjaan = document.querySelector(
      '[name="formValidationPekerjaan"]'
    );
    const wa = document.querySelector('[name="formValidationWA"]');

    nik.addEventListener("input", (event) => {
      const val = event.target.value;

      if (kk.value != "") {
        nik.classList.remove("is-invalid");

        if (val != "" && val.length == 16) {
          $.ajax({
            url: BASE_URL + "/getDataOrtuByNik?nik=" + val,
            type: "GET",
            dataType: "json",
            success: (e) => {
              nameOrtu.disabled = false;
              pendapatan.disabled = false;
              pekerjaan.disabled = false;
              wa.disabled = false;
              if (e.data != null) {
                var data = e.data;

                nameOrtu.value = data.name;
                if (data.relation != null) {
                  document.querySelector(
                    '[name="formValidationHubungan"][value="' +
                      data.relation +
                      '"]'
                  ).checked = true;
                } else {
                  document.querySelector(
                    '[name="formValidationHubungan"][value="Ayah"]'
                  ).checked = true;
                }

                pendapatan.value = data.income;
                pekerjaan.value = data.occupation;
                wa.value = data.mobileno;
              } else {
                nameOrtu.value = "";
                document.querySelector(
                  '[name="formValidationHubungan"][value="Ayah"]'
                ).checked = true;
                pendapatan.value = "";
                pekerjaan.value = "";
                wa.value = "";
              }
            },
          });
        } else {
          nik.classList.add("is-invalid");

          nameOrtu.disabled = true;
          nameOrtu.value = "";
          document.querySelector(
            '[name="formValidationHubungan"][value="Ayah"]'
          ).checked = true;
          pendapatan.disabled = true;
          pendapatan.value = "";
          pekerjaan.disabled = true;
          pekerjaan.value = "";
          wa.disabled = true;
          wa.value = "";
        }
      } else {
        alert("Nomor KK harus diisi");
        nik.classList.add("is-invalid");
        kk.focus();
        nik.value = "";
      }
    });

    kk.addEventListener("input", (event) => {
      const val = event.target.value;
      if (val != "") {
        nik.classList.remove("is-invalid");
      }
    });

    const FormValidation1 = FormValidation.formValidation(
      wizardValidationFormStep1,
      {
        fields: {
          formValidationParentkk: {
            validators: {
              notEmpty: {
                message: "Nomor Kartu Keluarga wajib diisi",
              },
              stringLength: {
                min: 16,
                max: 16,
                message: "Nomor Kartu Keluarga minimal 16 angka",
              },
              regexp: {
                regexp: /^[0-9]+$/,
                message: "Wajib diisi dengan angka",
              },
            },
          },
          formValidationNik: {
            validators: {
              notEmpty: {
                message: "Nomor Ktp wajib diisi",
              },
              stringLength: {
                min: 16,
                max: 16,
                message: "Nomor Ktp minimal 16 angka",
              },
              regexp: {
                regexp: /^[0-9]+$/,
                message: "Wajib diisi dengan angka",
              },
            },
          },
          formValidationParentName: {
            validators: {
              notEmpty: {
                message: "Nama wajib diisi",
              },
            },
          },
          formValidationPekerjaan: {
            validators: {
              notEmpty: {
                message: "Nama Pekerjaan wajib diisi",
              },
            },
          },
          formValidationPendapatan: {
            validators: {
              notEmpty: {
                message: "Pendapatan wajib diisi",
              },
            },
          },
          formValidationWA: {
            validators: {
              notEmpty: {
                message: "Nomor Whatsapp wajib diisi",
              },
            },
          },
        },
        plugins: {
          trigger: new FormValidation.plugins.Trigger(),
          bootstrap5: new FormValidation.plugins.Bootstrap5({
            // Use this for enabling/changing valid/invalid class
            // eleInvalidClass: '',
            eleValidClass: "",
            rowSelector: function (field, ele) {
              // field is the field name & ele is the field element
              switch (field) {
                case "formValidationPendapatan":
                case "formValidationPekerjaan":
                case "formValidationWA":
                  return ".col-sm-4";
                default:
                  return ".col-sm-6";
              }
            },
          }),
          autoFocus: new FormValidation.plugins.AutoFocus(),
        },
        init: (instance) => {
          instance.on("plugins.message.placed", function (e) {
            //* Move the error message out of the `input-group` element
            if (e.element.parentElement.classList.contains("input-group")) {
              e.element.parentElement.insertAdjacentElement(
                "afterend",
                e.messageElement
              );
            }
          });
        },
      }
    ).on("core.form.valid", function () {
      // Jump to the next step when all fields in the current step are valid
      const formBlock = $("#data-ortu-validation");

      $.ajax({
        url: BASE_URL + "/insDataOrtu",
        type: "POST",
        dataType: "json",
        data: {
          id: SEKOLAH_ID,
          noKk: kk.value,
          noNik: nik.value,
          name: nameOrtu.value,
          relation:
            document.querySelector('[name="formValidationHubungan"]:checked')
              ?.value || "",
          income: pendapatan.value,
          occupation: pekerjaan.value,
          mobileno: wa.value,
        },
        beforeSend: function () {
          loadingSpinner(formBlock, 1000);
        },
        success: (e) => {
          $(".uploaded_items").empty();
          resolveSpinner(formBlock, function () {
            document.querySelector('[name="parentId"]').value = e.data;
            var html = "";
            var items = JSON.parse(e.items);
            if (items.length) {
              $.each(items, function (k, v) {
                // Ganti _ dengan spasi dan ubah huruf pertama setiap kata menjadi kapital
                var labelText = v
                  .replace(/_/g, " ") // Ganti _ dengan spasi
                  .replace(/\b\w/g, function (match) {
                    return match.toUpperCase();
                  }); // Ubah huruf pertama setiap kata jadi kapital

                // Buat nama untuk field input dan label
                var fieldName = "formValidation" + labelText.replace(/\s/g, "");

                // Tambahkan elemen HTML ke dalam DOM
                var html = "";
                html += '<div class="col-sm-6">';
                html +=
                  '<label class="form-label" for="' +
                  fieldName +
                  '">' +
                  labelText +
                  "</label>";
                html +=
                  '<input type="file" class="form-control" id="' +
                  fieldName +
                  '" name="' +
                  fieldName +
                  '" />';
                html += "</div>";

                // Tambahkan HTML ke form setelah pembuatan
                $(".uploaded_items").append(html); // Make sure to append to the right container

                // Tambahkan field validasi menggunakan FormValidation2 setelah field ditambahkan
                FormValidation2.addField(fieldName, {
                  validators: {
                    notEmpty: {
                      message: labelText + " harus diunggah.", // Pesan validasi dinamis
                    },
                    file: {
                      extension: "pdf,png,jpeg,jpg",
                      type: "application/pdf,image/png,image/jpg,image/jpeg",
                      message: "File wajib image atau pdf",
                    },
                  },
                });
              });
            } else {
              html +=
                "Tidak ada metode Virtual Account yang tersedia saat ini. Silakan coba beberapa saat lagi atau pilih metode pembayaran lain.";
              $(".uploaded_items").append(html);
            }

            validationStepper.next();
          });
        },
        error: function (xhr) {
          const msg = xhr.responseJSON?.message || "Gagal terhubung ke server";
          rejectSpinner(formBlock, msg);
        },
      });
    });

    // Validation Data Siswa
    const FormValidation2 = FormValidation.formValidation(
      wizardValidationFormStep2,
      {
        fields: {
          formValidationName: {
            validators: {
              notEmpty: {
                message: "Nama wajib diisi",
              },
              stringLength: {
                min: 2,
                message: "The name must be more than 2 characters long",
              },
              regexp: {
                regexp: /^[a-zA-Z0-9 ]+$/,
                message:
                  "The name can only consist of alphabetical, number and space",
              },
            },
          },
          formValidationReligion: {
            validators: {
              notEmpty: {
                message: "Agama wajib diisi",
              },
            },
          },
          formValidationTempat: {
            validators: {
              notEmpty: {
                message: "Tempat wajib diisi",
              },
            },
          },
          formValidationDob: {
            validators: {
              notEmpty: {
                message: "Tanggal wajib diisi",
              },
              date: {
                format: "YYYY/MM/DD",
                message: "The value is not a valid date",
              },
            },
          },
        },
        plugins: {
          trigger: new FormValidation.plugins.Trigger(),
          bootstrap5: new FormValidation.plugins.Bootstrap5({
            // Use this for enabling/changing valid/invalid class
            // eleInvalidClass: '',
            eleValidClass: "",
            rowSelector: function (field, ele) {
              // field is the field name & ele is the field element
              switch (field) {
                case "formValidationNikAnak":
                case "formValidationGender":
                case "formValidationReligion":
                  return ".col-sm-4";
                default:
                  return ".col-sm-6";
              }
            },
          }),
          autoFocus: new FormValidation.plugins.AutoFocus(),
        },
      }
    ).on("core.form.valid", function () {
      let originalForm = $("#wizard-validation-form")[0];
      let newFormData = new FormData();

      newFormData.append("id", SEKOLAH_ID);

      // Tambahkan file upload yang valid
      $('.uploaded_items input[type="file"]').each(function () {
        let input = this;
        let name = input.name;
        if (input.files.length > 0) {
          newFormData.append(`dokumen[${name}]`, input.files[0]);
        }
      });

      // Loop field lain, tambahkan selain yang ingin dihapus
      $(originalForm)
        .serializeArray()
        .forEach(function (item) {
          let excluded = [
            "formValidationParentkk",
            "formValidationNik",
            "formValidationHubungan",
            "formValidationParentName",
            "formValidationWA",
            "formValidationPekerjaan",
            "formValidationPendapatan",
          ];
          if (!excluded.includes(item.name)) {
            newFormData.append(item.name, item.value);
          }
        });

      const formBlock = $("#data-siswa-validation");

      $.ajax({
        url: BASE_URL + "/insStudentAdmission",
        type: "POST",
        dataType: "json",
        processData: false,
        contentType: false,
        data: newFormData,
        beforeSend: function () {
          loadingSpinner(formBlock, 60000);
        },
        success: (e) => {
          console.log("success insStudentAdmission 1");
          var data = e.data;
          $("#select-bank").empty();

          resolveSpinner(formBlock, function () {
            console.log("success insStudentAdmission 2");
            if (data.va_generated === true) {
              document.querySelector('[name="studentId"]').value = data.id;
              $("#formValidationBiaya").text(data.amount);

              var html = "";
              if (data.bank.length) {
                $.each(data.bank, function (k, v) {
                  html += '<div class="col-sm-4">';
                  html += '<div class="form-check">';
                  html +=
                    '<input name="formValidationVA" class="form-check-input" type="radio" value="' +
                    v.fee_admin +
                    '" id="' +
                    v.paymentMethod +
                    '" data-name="' +
                    v.paymentName +
                    '" data-image="' +
                    v.paymentImage +
                    '" />';
                  html +=
                    '<label class="form-check-label" for="' +
                    v.paymentMethod +
                    '">';
                  html += '<img src="' + v.paymentImage + '" width="40"> ';
                  html += v.paymentName;
                  html += "</label></div></div>";
                });
              } else {
                html =
                  "Tidak ada metode Virtual Account yang tersedia saat ini. Silakan coba beberapa saat lagi atau pilih metode pembayaran lain.";
              }

              $("#select-bank").append(html);

              // Hapus field lama jika sudah ada
              FormValidation3.removeField("formValidationVA", false);

              // Tambahkan ulang field validasi
              FormValidation3.addField("formValidationVA", {
                validators: {
                  notEmpty: {
                    message: "Pilih metode pembayaran",
                  },
                },
              });

              validationStepper.next();
            } else {
              Swal.fire({
                icon: "success",
                title: "Berhasil",
                text: "Data berhasil disimpan!",
                confirmButtonText: "OK",
                confirmButtonColor: "#28a745", // warna hijau sukses
                customClass: {
                  confirmButton: "btn btn-success waves-effect waves-light",
                },
                buttonsStyling: false,
              }).then(() => {
                location.reload(); // Reload halaman setelah tombol ditekan
              });
            }
          });
        },
        error: function (xhr) {
          const msg = xhr.responseJSON?.message || "Gagal terhubung ke server";
          rejectSpinner(formBlock, msg);
        },
      });
    });

    // Flatpickr
    const flatpickrDate = document.querySelector('[name="formValidationDob"]');

    if (flatpickrDate) {
      flatpickrDate.flatpickr({
        enableTime: false,
        // See https://flatpickr.js.org/formatting/
        dateFormat: "Y/m/d",
        // After selecting a date, we need to revalidate the field
        onChange: function () {
          FormValidation2.revalidateField("formValidationDob");
        },
      });
    }

    // Pembayaran Siswa
    const FormValidation3 = FormValidation.formValidation(
      wizardValidationFormStep3,
      {
        fields: {
          formValidationVA: {
            validators: {
              notEmpty: {
                message: "Pilih metode pembayaran",
              },
            },
          },
          formValidationCheckbox: {
            validators: {
              notEmpty: {
                message: "Syarat dan ketentuan wajib dicentang",
              },
            },
          },
        },
        plugins: {
          trigger: new FormValidation.plugins.Trigger(),
          bootstrap5: new FormValidation.plugins.Bootstrap5({
            // Use this for enabling/changing valid/invalid class
            // eleInvalidClass: '',
            eleValidClass: "",
            rowSelector: function (field, ele) {
              if (field === "formValidationVA") {
                return "#select-bank"; // Atau selector yang membungkus semua radio VA
              }

              return ".col-sm-12";
            },
          }),
          autoFocus: new FormValidation.plugins.AutoFocus(),
        },
      }
    ).on("core.form.valid", function () {
      // FormValidation3.revalidateField('formValidationVA');
      // You can submit the form
      // wizardValidationForm.submit()
      var order_id = document.querySelector('[name="studentId"]').value;
      let form = document.getElementById("wizard-validation-form");
      var name = form.elements["formValidationName"].value;
      var amount = document.getElementById("formValidationBiaya");
      var d = amount.innerHTML.replace(/\D/g, "");
      var fee = document.querySelector('[name="formValidationVA"]').value;
      var total = parseInt(d) + parseInt(fee);
      var bank = document.querySelector('[name="formValidationVA"]:checked');
      var bank_code = bank ? bank.getAttribute("id") : null;
      var imageBank = bank ? bank.getAttribute("data-image") : null;

      // Menggabungkan semua parameter dalam satu objek
      var parameters = btoa(
        JSON.stringify({
          id: SEKOLAH_ID,
          order_id: "ppdb" + order_id,
          name: name,
          amount: d,
          total: total,
          fee: fee,
          imageBank: imageBank,
          methodbank: bank ? bank.id : null,
          bankName: bank ? bank.getAttribute("data-name") : null,
          bankCode: bank_code,
          status: 0,
        })
      );

      const formBlock = $("#pembayaran-validation");

      $.ajax({
        url: BASE_URL + "/updatePaymentAdmission",
        type: "POST",
        dataType: "json",
        data: parameters,
        beforeSend: function () {
          loadingSpinner(formBlock, 1000);
        },
        success: (res) => {
          if (res.status === true) {
            openPaymentModal(res.data);
          } else {
            rejectSpinner(formBlock, res.message);
          }
        },
        error: function (xhr) {
          const msg = xhr.responseJSON?.message || "Gagal terhubung ke server";
          rejectSpinner(formBlock, msg);
        },
      });
    });

    function openPaymentModal(response) {
        // Hapus countdown lama
        if (window.countdownInterval) clearInterval(window.countdownInterval);

        // Set countdown baru
        const targetDate = new Date(
            response.year,
            response.month,
            response.day,
            response.hours,
            response.minutes,
            response.seconds
        );

        function updateCountdown() {
            const now = new Date();
            const diff = targetDate - now;
            if (diff <= 0) {
                document.getElementById("countdown").innerHTML = "Waktu telah habis!";
                clearInterval(window.countdownInterval);
                return;
            }
            const hours = String(Math.floor((diff % (1000 * 86400)) / (1000 * 3600))).padStart(2, "0");
            const minutes = String(Math.floor((diff % (1000 * 3600)) / (1000 * 60))).padStart(2, "0");
            const seconds = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2, "0");

            document.getElementById("countdown").innerHTML = `${hours} : ${minutes} : ${seconds}`;
        }

        window.countdownInterval = setInterval(updateCountdown, 1000);
        updateCountdown();

        // Isi modal
        document.getElementById("expired-date").innerHTML = "Jatuh tempo pada tanggal " + response.expired;
        document.querySelector("#imageBank").src = response.image_bank;
        document.getElementById("totalBayar").innerHTML = response.total_bayar;
        document.getElementById("numberVa").innerHTML = response.vaNumber;
        document.querySelector('[name="order_id"]').value = response.order_id;
        document.querySelector('[name="paymentUrl"]').value = response.paymentUrl || '';
        document.querySelector('[name="merchantCode"]').value = response.merchantCode || '';

        // Accordion
        const accordion = $("#accordionStyle1").empty();
        response.cara_bayar.forEach((v, i) => {
            let html = `
                <div class="accordion-item card">
                    <h2 class="accordion-header">
                        <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionStyle1-${i}" aria-expanded="false">
                            ${v.via}
                        </button>
                    </h2>
                    <div id="accordionStyle1-${i}" class="accordion-collapse collapse" data-bs-parent="#accordionStyle1">
                        <div class="accordion-body pt-5 border-top">
                            ${v.how.map(h => `<p class="mb-0">${h}</p>`).join('')}
                        </div>
                    </div>
                </div>
            `;
            accordion.append(html);
        });

        // Tampilkan modal
        const modal = new bootstrap.Modal(document.getElementById('formPayment'));
        modal.show();
    }

    wizardValidationNext.forEach((item) => {
      item.addEventListener("click", (event) => {
        // When click the Next button, we will validate the current step
        switch (validationStepper._currentIndex) {
          case 0:
            FormValidation1.validate();
            break;

          case 1:
            FormValidation2.validate();
            break;

          case 2:
            FormValidation3.validate();
            break;

          default:
            break;
        }
      });
    });

    wizardValidationPrev.forEach((item) => {
      item.addEventListener("click", (event) => {
        switch (validationStepper._currentIndex) {
          case 2:
            validationStepper.previous();
            break;

          case 1:
            validationStepper.previous();
            break;

          case 0:

          default:
            break;
        }
      });
    });
  }

  $(".payment-submit").on("click", function (e) {
    var orderId = document.getElementById("order_id").value;
    const formBlock = $("#formPayment");

    $.ajax({
      url: BASE_URL + "/submitPaymentAdmission",
      type: "POST",
      data: {
        merchantOrderId: orderId,
      },
      beforeSend: function () {
        loadingSpinner(formBlock, 1000);
      },
      success: (res) => {
        if (res.status === true) {
          resolveSpinner(formBlock, function () {
            location.reload(true);
          });
        } else {
          rejectSpinner(formBlock, res.message);
        }
      },
    });
  });
})();
